#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"
#include "../scorpion.h"

static Obj3d Ping;
static Obj3d *pPlaque;
static float Matrix[16], Matrix2[16], Matrix3[16], Matrix4[16], Gouraud[16], Gouraud2[16];

// panel
static FbVertex pVertexIn[] =
{
	{-600,-1500,-350,  255.f,255.f,0,   0,0,0.f, {0.f, 256.f, 0.f}},
	{600,-1500,-350,  0.f,255.f,255.f,   0,0,0.f, {256.f, 256.f, 0.f}},
	{600,-2080,-350,  255.f,0,255.f,   0,0,0.f, {256.f, 0.f, 0.f}},
	{-600,-2080,-350,  170.f,170.f,170.f,   0,0,0.f, {0.f, 0.f, 0.f}},
};
static GrVertex pVertexOut[sizeof(pVertexIn)/sizeof(FbVertex)] =
{
	{0,0,0, 255.f,255.f,128.f},
	{0,0,0, 128.f,255.f,255.f},
	{0,0,0, 255.f,128.f,255.f},
	{0,0,0, 170.f,170.f,170.f},
};
static Face pFace[] =
{
	{0,1,2},
	{2,3,0},
};
static Obj3d Panneau = 
{
	pVertexIn,
	pVertexOut,
	sizeof(pVertexIn)/sizeof(FbVertex), // Nb Vertexes
	pFace,
	sizeof(pFace)/sizeof(Face)
};

// mast
static FbVertex pVertexIn2[] =
{
	{-3550,-5000,-50,  0.f,0,0,   0,0,0.f, {0.f, 256.f, 0.f}},
	{-3450,-5000,-50,  0.f,0,0,   0,0,0.f, {256.f, 256.f, 0.f}},
	{-3450,-5000,50,  0.f,0,0,   0,0,0.f, {256.f, 0.f, 0.f}},
	{-3550,-5000,50,  0.f,0,0,   0,0,0.f, {0.f, 0.f, 0.f}},
	{-3550,2050,-50,  0.f,0,0,   0,0,0.f, {0.f, 256.f, 0.f}},
	{-3450,2050,-50,  0.f,0,0,   0,0,0.f, {256.f, 256.f, 0.f}},
	{-3450,2050,50,  0.f,0,0,   0,0,0.f, {256.f, 0.f, 0.f}},
	{-3550,2050,50,  0.f,0,0,   0,0,0.f, {0.f, 0.f, 0.f}},
};
static GrVertex pVertexOut2[sizeof(pVertexIn2)/sizeof(FbVertex)];
static Face pFace2[] =
{
	{0,1,5},
	{5,4,0},
	{1,2,6},
	{6,5,1},
	{2,3,7},
	{7,6,2},
	{3,0,4},
	{4,7,3},
};
static Obj3d Mast = 
{
	pVertexIn2,
	pVertexOut2,
	sizeof(pVertexIn2)/sizeof(FbVertex), // Nb Vertexes
	pFace2,
	sizeof(pFace2)/sizeof(Face)
};

Obj3d *pFlag;

void LInit_Ping()
{
	FILE *file;
	DWORD Cpt1;
	unsigned short A,B,C;
	float fMinX,fMaxX,fMinY,fMaxY;
	float fRangeX, fRangeY;
	DWORD dwDummy;

	// load ping!
	//file = fopen("Ping.n3d", "rb");
	file = fopen(PackageName, "rb");
	SeekToSubfile(file, Ping3d, &dwDummy);
	fread(&Ping.NbVertex, 4, 1, file);
	Ping.pVertexIn = (FbVertex*)malloc(sizeof(FbVertex)*Ping.NbVertex);
	Ping.pVertexOut = (GrVertex*)malloc(sizeof(GrVertex)*Ping.NbVertex);
	for(Cpt1=0;Cpt1<Ping.NbVertex;Cpt1++)
	{
		fread(&Ping.pVertexIn[Cpt1].x, 4, 1, file);
		fread(&Ping.pVertexIn[Cpt1].y, 4, 1, file);
		fread(&Ping.pVertexIn[Cpt1].z, 4, 1, file);
		fread(&Ping.pVertexIn[Cpt1].tmuvtx[0].sow, 4, 1, file);
		fread(&Ping.pVertexIn[Cpt1].tmuvtx[0].tow, 4, 1, file);
	}
	fread(&Ping.NbFaces, 4, 1, file);
	Ping.pFace = (Face*)malloc(sizeof(Face)*Ping.NbFaces);
	for(Cpt1=0;Cpt1<Ping.NbFaces;Cpt1++)
	{
		fread(&A, 2, 1, file);
		fread(&B, 2, 1, file);
		fread(&C, 2, 1, file);
		Ping.pFace[Cpt1].A = A;
		Ping.pFace[Cpt1].B = B;
		Ping.pFace[Cpt1].C = C;
	}
	fclose(file);
	// end load ping!

	// stand, little ping!
	BeIdentityMatrix(Matrix);
	ScaleMatrix(Matrix, 17,17,17);
	RotateXMatrix(Matrix2, Matrix, 8192/4); // PI2 <=> 8192; PI/2 <=> 8192/4
	TranslateMatrix(Matrix2, 0, -1700, 0);
	ApplyMatrix(&Ping, Matrix2);
	// end stand, little ping!

	// be illuminated, little ping!
	ComputeGouraud(&Ping);
	BeIdentityMatrix(Gouraud);
	// end be illuminated, little ping!

	// be scaled, little ping!
	fMinX = 0;	fMinY = 0;
	fMaxX = 0;	fMaxY = 0;
	for(Cpt1=0;Cpt1<Ping.NbVertex;Cpt1++)
	{
		Ping.pVertexIn[Cpt1].r /= 8.f;
		Ping.pVertexIn[Cpt1].g /= 8.f;
		Ping.pVertexIn[Cpt1].b /= 8.f;
		if (Ping.pVertexIn[Cpt1].x<fMinX)
			fMinX = Ping.pVertexIn[Cpt1].x;
		if (Ping.pVertexIn[Cpt1].x>fMaxX)
			fMaxX = Ping.pVertexIn[Cpt1].x;
		if (Ping.pVertexIn[Cpt1].y<fMinY)
			fMinY = Ping.pVertexIn[Cpt1].y;
		if (Ping.pVertexIn[Cpt1].y>fMaxY)
			fMaxY = Ping.pVertexIn[Cpt1].y;
	}

	fRangeX = fMaxX - fMinX;
	fRangeY = fMaxY - fMinY;

	for(Cpt1=0;Cpt1<Ping.NbVertex;Cpt1++)
	{
		if (Ping.pVertexIn[Cpt1].z>0)
			Ping.pVertexIn[Cpt1].tmuvtx[0].sow = 
			(Ping.pVertexIn[Cpt1].x - fMinX)*128.f/fRangeX;
		else
			Ping.pVertexIn[Cpt1].tmuvtx[0].sow = 
			(Ping.pVertexIn[Cpt1].x - fMinX)*128.f/fRangeX+128;
		Ping.pVertexIn[Cpt1].tmuvtx[0].tow = (Ping.pVertexIn[Cpt1].y - fMinY)*256.f/fRangeY;
	}
	// end be scaled, little ping!

	// the floor !
	pPlaque = GenerateFloor(4,4, 160000, 160000, 25600, 25600);
	BeIdentityMatrix(Matrix);
	RotateXMatrix(Matrix2, Matrix, 8192/4);
	TranslateMatrix(Matrix2, 0, 350, 1);
	ApplyMatrix(pPlaque, Matrix2);

	// flag
	pFlag = GenerateFloor(10, 10, 1000, 500, 256, 256);
	BeIdentityMatrix(Matrix);
	TranslateMatrix(Matrix, -2600, -4500, 0);
	ApplyMatrix(pFlag, Matrix);

	PrepareTextureFromArray(g_PicPing, 256, 256, &g_TexturePing);
	PrepareTextureFromArray(g_PicPanneau, 256, 256, &g_TexturePanneau);
	PrepareTextureFromArray(g_PicSolPing, 256, 256, &g_TextureSolPing);
}

void QInit_Ping()
{
	grSstControl(GR_CONTROL_ACTIVATE);
	grDepthBufferMode(GR_DEPTHBUFFER_WBUFFER);
	grDepthBufferFunction(GR_CMP_LESS);
	grConstantColorValue(192<<24);
	grAlphaCombine(GR_COMBINE_FUNCTION_BLEND_OTHER, GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	/*grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_CONSTANT, FXFALSE);*/
	//
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	/*grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);*/

	grChromakeyValue(0);
	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	//grFogMode(GR_FOG_DISABLE);
	grFogMode(GR_FOG_WITH_TABLE);
	grFogColorValue(0);
	grFogTable(g_FogPlanes);
	grCullMode(FXFALSE);

	DownloadTexture(&g_TexturePing);
	DownloadTexture(&g_TexturePanneau);
	DownloadTexture(&g_TextureSolPing);
}

void Effect_Ping()
{
	float fTmp;
	int Cpt1, Cpt2, Cpt3;
	static DWORD SolPingConstant = 0xffffff;
	DWORD dwTmp;

	fTmp = g_demostate.TickInEffect/300.f;

	BeIdentityMatrix(Matrix);
	BeIdentityMatrix(Gouraud);

	RotateXMatrix(Matrix2, Matrix, 250+249*SinTable[(g_demostate.TickInEffect*4)&8191]);
	RotateYMatrix(Matrix, Matrix2, 250*SinTable[(g_demostate.TickInEffect*8)&8191]);
	TranslateMatrix(Matrix, 0, 1700, 0);
	RotateXMatrix(Gouraud2, Gouraud, 250+249*SinTable[(g_demostate.TickInEffect*4)&8191]);
	//RotateYMatrix(Gouraud, Gouraud2, 250+249*SinTable[(g_demostate.TickInEffect*8)&8191]);
	RotateYMatrix(Gouraud, Gouraud2, 350+349*SinTable[(g_demostate.TickInEffect*8)&8191]);

	TranslateMatrix(Matrix, 0, 1250, 4500);

	if (g_demostate.TickInEffect<3000)
	{
		TranslateMatrix(Matrix, 0, 0, -3000);
	}
	else
	{
		if (g_demostate.TickInEffect<3250)
		{
			TranslateMatrix(Matrix, 0, 0, -3000+((int)g_demostate.TickInEffect-3000)*12);
		}
		else
		{
			if (g_demostate.TickInEffect>5000)
			{
				dwTmp = (5000+1024-g_demostate.TickInEffect)/4;
				SolPingConstant = dwTmp + (dwTmp<<8) + (dwTmp<<16);
				TranslateMatrix(Matrix, (g_demostate.TickInEffect-5000)*2, 0, -(int)(g_demostate.TickInEffect-5000)*12);
			}
		}
	}

	Cpt3 = 0;

	for(Cpt1=0;Cpt1<11;Cpt1++)
	{
		for(Cpt2=0;Cpt2<11;Cpt2++)
		{
			pFlag->pVertexIn[Cpt3].z = 
				256.f*SinTable[(Cpt1*1024+g_demostate.TickInEffect*8)&8191]
				+ 256.f*CosTable[(Cpt2*1024+g_demostate.TickInEffect*8)&8191];
			pFlag->pVertexIn[Cpt3].z /= (11-Cpt2);
			Cpt3++;
		}
	}

	SelectTexture(g_TexturePing);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	DrawWithMatrix(&Ping, Matrix, true, Gouraud, 0);

	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_ITERATED, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	SelectTexture(g_TexturePanneau);
	DrawWithMatrix(&Panneau, Matrix, false, Gouraud, 0);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	DrawWithMatrix(pFlag, Matrix, false, Gouraud, 0);

	grConstantColorValue(0x808080);
	grColorCombine(GR_COMBINE_FUNCTION_LOCAL,
					GR_COMBINE_FACTOR_ONE,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	DrawWithMatrix(&Mast, Matrix, false, Gouraud, 0);

	grConstantColorValue(SolPingConstant);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
					GR_COMBINE_FACTOR_LOCAL,
					GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	SelectTexture(g_TextureSolPing);
	DrawWithMatrix(pPlaque, Matrix, false, NULL, 0);
}

void ByeBye_Ping()
{
	FreeTexture(&g_TextureSolPing);
	FreeTexture(&g_TexturePanneau);
	FreeTexture(&g_TexturePing);
}
